from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick up 'dice1' from 'ready-pose'
        # 'dice1' is assumed to be located at 'ready-pose' (as per provided plan).
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 2: Place 'dice1' into the open drawer (drawer1), also at 'ready-pose'
        # For 'execute_place', axis=2 (top approach) is suitable for objects like dice.
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
