from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle plan execution for: Store a dice in the open drawer.
    Steps (from specification):
      1. execute_pick(dice1, ready-pose)
      2. execute_place(dice1, drawer1, ready-pose)
    """
    robot = RobotController()
    
    # Robust error handling for fetches and skill execution
    try:
        # Step 1: Pick up dice1 at ready-pose
        #   - Object: "dice1"
        #   - Location: "ready-pose"
        #   - Axis: 2 (general object grasp; approach from above)
        dice1_pose = Object.get("dice1", None)
        if dice1_pose is None:
            raise KeyError("dice1 not found in Object list")
        robot.execute_movement(dice1_pose, mode=1, axis=2)
        
        # Step 2: Place dice1 into drawer1 at ready-pose
        #   - Place location: "drawer_top_place_left" or similar, but by convention, we'll use the drawer pose
        #   - The "Object" dict may not contain "drawer1" directly; map to a known placement pose
        #   - The plan parameters: ["dice1", "drawer1", "ready-pose"]
        #   - Let's use Object["drawer_top_place_left"] or, if not present, simply reuse ready-pose
        drawer_place_pose = Object.get("drawer_top_place_left", Object.get("ready-pose", None))
        if drawer_place_pose is None:
            raise KeyError("drawer_top_place_left and ready-pose not found in Object list")
        robot.execute_movement(drawer_place_pose, mode=2, axis=2)
        
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()