from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick up the dice (dice1) from its location.
        # axis=2 for general object pick (z-axis approach)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 2: Place the dice into the already open drawer.
        # Use the left place position for the top drawer as the open drawer location.
        # axis=2 for general object place (z-axis approach)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()