# run_skeleton_task.py (Completed with Exploration Phase for Missing Predicate)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # Feedback indicates (drawer-closed drawer1) is missing or needs to be explored.
        # We will attempt to use available skills to explore the state of drawer1.

        # Assumptions for object names and locations (replace with actual names if different)
        drawer_name = 'drawer1'
        handle_name = 'handle1'
        robot_location = 'loc_robot'  # Replace with actual robot location key if needed
        drawer_location = 'loc_drawer1'  # Replace with actual drawer location key if needed

        # Try to get actual positions from the environment
        try:
            drawer_pos = positions.get(drawer_name, None)
            handle_pos = positions.get(handle_name, None)
            robot_pos = positions.get('robot', None)
        except Exception as e:
            print("[Exploration] Could not retrieve positions:", e)
            drawer_pos = None
            handle_pos = None
            robot_pos = None

        # Step 1: Move robot to drawer location if not already there
        try:
            # If robot_pos and drawer_pos are available and different, move
            if robot_pos is not None and drawer_pos is not None and robot_pos != drawer_pos:
                print(f"[Exploration] Moving robot from {robot_pos} to {drawer_pos}")
                obs, reward, done = execute_go(env, task, robot_pos, drawer_pos)
                if done:
                    print("[Exploration] Task ended during move!")
                    return
                robot_pos = drawer_pos
            else:
                print("[Exploration] Robot already at drawer location or positions unknown.")
        except Exception as e:
            print("[Exploration] Exception during execute_go:", e)

        # Step 2: Try to pull the drawer to check if it is closed/locked/unlocked
        # This will help us discover the (drawer-closed drawer1) predicate
        try:
            print(f"[Exploration] Attempting to pick handle {handle_name} at {drawer_location}")
            obs, reward, done = execute_pick(env, task, handle_name, drawer_location)
            if done:
                print("[Exploration] Task ended during pick!")
                return
        except Exception as e:
            print("[Exploration] Exception during execute_pick:", e)

        try:
            print(f"[Exploration] Attempting to pull drawer {drawer_name} using handle {handle_name} at {drawer_location}")
            obs, reward, done = execute_pull(env, task, drawer_name, handle_name, drawer_location)
            if done:
                print("[Exploration] Task ended during pull!")
                return
        except Exception as e:
            print("[Exploration] Exception during execute_pull:", e)
            print("[Exploration] This may indicate the drawer is closed or locked (missing predicate).")

        # Step 3: If pull failed, the drawer may be closed or locked.
        # The missing predicate is likely (drawer-closed drawer1).
        print("[Exploration] If pull failed, (drawer-closed drawer1) is likely missing or not satisfied.")

        # === End of Exploration Phase ===

        # === Main Task Plan (Example) ===
        # Here you would continue with the oracle plan, using only the available skills.
        # For demonstration, we show a generic sequence (replace with actual plan as needed):

        # Example: Open the drawer if possible, place an object inside, then close the drawer.
        # Replace 'object1' and other names with actual object names from your environment.

        object_to_place = 'object1'  # Replace with actual object name
        try:
            # Pick up the object from the floor
            print(f"[Task] Attempting to pick up {object_to_place} at {drawer_location}")
            obs, reward, done = execute_pick(env, task, object_to_place, drawer_location)
            if done:
                print("[Task] Task ended during pick!")
                return
        except Exception as e:
            print("[Task] Exception during execute_pick:", e)

        try:
            # Place the object in the drawer
            print(f"[Task] Attempting to place {object_to_place} in {drawer_name} at {drawer_location}")
            obs, reward, done = execute_place(env, task, object_to_place, drawer_name, drawer_location)
            if done:
                print("[Task] Task ended during place!")
                return
        except Exception as e:
            print("[Task] Exception during execute_place:", e)

        try:
            # Close the drawer
            print(f"[Task] Attempting to push (close) {drawer_name} at {drawer_location}")
            obs, reward, done = execute_push(env, task, drawer_name, drawer_location)
            if done:
                print("[Task] Task ended during push!")
                return
        except Exception as e:
            print("[Task] Exception during execute_push:", e)

        print("[Task] Task plan executed. Check if goal state is achieved.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
