# run_skeleton_task.py (Completed with Exploration Phase for Missing Predicate)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # Feedback indicates (drawer-closed drawer1) is missing or needs to be checked.
        # We will attempt to use available skills to explore the state of drawer1.

        # Assumptions for object names (update as per your environment):
        # - drawer1: the drawer to be explored
        # - handle1: the handle object attached to drawer1
        # - robot starts at some initial location, e.g., 'loc_start'
        # - drawer1 is at location 'loc_drawer'
        # - handle1 is at the same location as drawer1

        # You may need to update these names based on your environment's object naming
        drawer_name = 'drawer1'
        handle_name = 'handle1'
        robot_location = None
        drawer_location = None
        handle_location = None

        # Try to infer locations from positions dictionary
        for obj, pos in positions.items():
            if 'drawer1' in obj:
                drawer_location = obj  # or positions[obj] if needed
            if 'handle1' in obj:
                handle_location = obj
        # For this example, assume locations are the same as object names
        # If your environment uses separate location names, update accordingly

        # Find robot's current location (if available)
        # This may require parsing obs or positions; here we use a placeholder
        robot_location = 'robot_start'  # Replace with actual robot location if available

        # For demonstration, set drawer_location and handle_location to 'drawer1' and 'handle1'
        # If your environment uses location objects, update accordingly
        drawer_location = 'drawer1'
        handle_location = 'handle1'

        print("[Exploration] Starting exploration to determine missing predicate (drawer-closed {})".format(drawer_name))

        # Step 1: Move robot to drawer location if not already there
        try:
            # If robot_location != drawer_location, move
            if robot_location != drawer_location:
                print("[Exploration] Moving robot from {} to {}".format(robot_location, drawer_location))
                obs, reward, done = execute_go(env, task, robot_location, drawer_location)
                robot_location = drawer_location
        except Exception as e:
            print("[Exploration] Error during execute_go:", e)

        # Step 2: Try to pick the handle (if required by your domain)
        try:
            print("[Exploration] Attempting to pick handle:", handle_name)
            obs, reward, done = execute_pick(env, task, handle_name, drawer_location)
        except Exception as e:
            print("[Exploration] Error during execute_pick:", e)

        # Step 3: Try to pull the drawer (this may reveal lock/closed state)
        try:
            print("[Exploration] Attempting to pull drawer:", drawer_name)
            obs, reward, done = execute_pull(env, task, drawer_name, handle_name, drawer_location)
            # If this succeeds, the drawer was closed and is now open
            print("[Exploration] Drawer was closed and is now open (predicate (drawer-closed {}) was true)".format(drawer_name))
        except Exception as e:
            print("[Exploration] Error during execute_pull (drawer may not be closed or is locked):", e)
            print("[Exploration] The predicate (drawer-closed {}) may be missing or false.".format(drawer_name))

        # Step 4: (Optional) Try to push the drawer closed again
        try:
            print("[Exploration] Attempting to push drawer closed:", drawer_name)
            obs, reward, done = execute_push(env, task, drawer_name, drawer_location)
            print("[Exploration] Drawer pushed closed.")
        except Exception as e:
            print("[Exploration] Error during execute_push:", e)

        # === End of Exploration Phase ===

        # === Main Task Plan (Oracle Plan Execution) ===
        # At this point, you can proceed with the main plan using the available skills.
        # For example, pick an object, place it in the drawer, etc.
        # The following is a placeholder for your actual plan logic.

        # Example: Pick up an object and place it in the drawer
        # Replace 'object1' with the actual object name and location as needed
        object_to_pick = 'object1'
        object_location = 'object1_location'  # Update as per your environment

        # Move to object location
        try:
            if robot_location != object_location:
                print("[Task] Moving robot from {} to {}".format(robot_location, object_location))
                obs, reward, done = execute_go(env, task, robot_location, object_location)
                robot_location = object_location
        except Exception as e:
            print("[Task] Error during execute_go to object:", e)

        # Pick the object
        try:
            print("[Task] Picking up object:", object_to_pick)
            obs, reward, done = execute_pick(env, task, object_to_pick, object_location)
        except Exception as e:
            print("[Task] Error during execute_pick for object:", e)

        # Move to drawer location
        try:
            if robot_location != drawer_location:
                print("[Task] Moving robot from {} to {}".format(robot_location, drawer_location))
                obs, reward, done = execute_go(env, task, robot_location, drawer_location)
                robot_location = drawer_location
        except Exception as e:
            print("[Task] Error during execute_go to drawer:", e)

        # Place the object in the drawer
        try:
            print("[Task] Placing object {} in drawer {}".format(object_to_pick, drawer_name))
            obs, reward, done = execute_place(env, task, object_to_pick, drawer_name, drawer_location)
        except Exception as e:
            print("[Task] Error during execute_place:", e)

        # (Optional) Close the drawer
        try:
            print("[Task] Closing the drawer:", drawer_name)
            obs, reward, done = execute_push(env, task, drawer_name, drawer_location)
        except Exception as e:
            print("[Task] Error during execute_push (close drawer):", e)

        print("[Task] Task completed.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()