"""Module to place one dice into the open drawer using RobotController."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to pick up a dice and place it into the open drawer."""
    robot = RobotController()

    try:
        # Step 1: execute_pick(dice, ready-pose)
        # Mapping: dice -> Object["dice"], ready-pose is the default pose for pick/place
        robot.execute_movement(Object["dice"], mode=1, axis=0)

        # Step 2: execute_place(dice, drawer1, ready-pose)
        # Mapping: place dice into drawer1 at ready-pose
        robot.execute_movement(Object["dice"], mode=2, axis=0)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main function to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()