"""Module to store a dice in the open drawer using RobotController."""
from Object_list import Object
from skill_mapping import RobotController

def store_dice_in_open_drawer():
    """Stores the dice in the open drawer."""
    robot = RobotController()
    try:
        # Step 1: Pick up the dice from the floor
        robot.execute_movement(Object["dice"], mode=1)
    except Exception as error:
        print(f"Error during execute_pick: {error}")

    try:
        # Step 2: Place the dice into the open drawer (drawer1)
        robot.execute_movement(Object["drawer_top_in"], mode=2)
    except Exception as error:
        print(f"Error during execute_place: {error}")

def main():
    """Main function to execute the store dice task."""
    store_dice_in_open_drawer()

if __name__ == "__main__":
    main()