"""Module to move a dice into an already open drawer using RobotController."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Move one dice to the already open drawer."""
    robot = RobotController()
    try:
        # Step 1: Pick up the dice from the floor at ready-pose
        robot.execute_movement(Object["dice"], mode=1, axis=0)
        # Step 2: Place the dice into the already open top drawer at ready-pose
        robot.execute_movement(Object["drawer_top_inside"], mode=2, axis=2)
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point for the task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()