"""Module to insert a dice into the open drawer using the robot controller."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Insert one dice into the open drawer."""
    robot = RobotController()

    try:
        # Step 1: Pick up the dice (assume "dice1" is the dice object, on the floor at "ready-pose")
        robot.execute_movement(Object["dice1"], mode=1, axis=0)

        # Step 2: Place the dice into the open drawer (assume "drawer1" is open at "ready-pose")
        robot.execute_movement(Object["dice1"], mode=2, axis=0)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main function to execute the dice insertion task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()