from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Move one dice to the drawer that's already open."""
    robot = RobotController()
    try:
        # Step 1: Pick up a dice from the floor at ready-pose
        # Let's use Object["dice1"] as the dice object
        robot.execute_movement(Object["dice1"], mode=1)
    except Exception as error:
        print(f"Error during execute_pick: {error}")

    try:
        # Step 2: Place the dice into the already open drawer (drawer1)
        # Use Object["drawer_top_place_center"] as the place pose
        robot.execute_movement(Object["drawer_top_place_center"], mode=2)
    except Exception as error:
        print(f"Error during execute_place: {error}")

def main():
    """Main entry point."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()