"""Module to place one dice into the open drawer."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Place one dice into the open drawer."""
    robot = RobotController()

    try:
        # Step 1: Pick up dice1 from ready-pose (axis=2 for general objects)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 2: Place dice1 into the open drawer1 at ready-pose (axis=2 for general objects)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point for placing one dice into the open drawer."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()