from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Put a single dice (dice1) in the already open drawer (drawer1)."""
    robot = RobotController()

    try:
        # Pick up dice1 at its current location
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Place dice1 into the already open drawer1
        robot.execute_movement(Object["drawer1"], mode=2, axis=2)
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point for the task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()