"""Module to move one dice to the drawer that's already open."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Move one dice to the drawer that's already open."""
    robot = RobotController()

    # Identify one dice on the floor
    dice_candidates = [obj for obj in ["dice1", "dice2"] if Object[obj].is_on_floor()]
    if not dice_candidates:
        print("No dice available on the floor.")
        return
    dice_to_move = dice_candidates[0]

    # Identify the open drawer
    open_drawers = [drawer for drawer in ["drawer1", "drawer2", "drawer3"] if Object[drawer].is_open()]
    if not open_drawers:
        print("No open drawer available.")
        return
    target_drawer = open_drawers[0]

    # Move robot to the dice location and pick it up
    dice_location = Object[dice_to_move].location
    robot.execute_movement(dice_location, mode=1, axis=2)

    # Move robot to the open drawer and place the dice inside
    drawer_location = Object[target_drawer].location
    robot.execute_movement(drawer_location, mode=2, axis=2)

def main():
    """Main entry point to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()