"""Module to store a dice in the open drawer using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Store a dice in the open drawer."""
    robot = RobotController()

    # Move to ready pose if not already there
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)
    except Exception:
        pass

    # Pick up dice1 from the floor at ready-pose (axis=2 for general object pick)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as error:
        print(f"Error during execute_pick for dice1: {error}")

    # Move to ready pose before placing
    try:
        robot.execute_movement(mode=8)
    except Exception:
        pass

    # Place dice1 into drawer1 at ready-pose (axis=2 for general object place)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as error:
        print(f"Error during execute_place for dice1: {error}")

    # Return to ready pose at the end
    try:
        robot.execute_movement(mode=8)
    except Exception:
        pass

def main():
    """Main function to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()