from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # === Step 1: Pick up the dice (choose dice1) ===
        # Assume dice1 is the single dice to move
        # Approach dice1 along z-axis (axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Optional: Move to safe ready pose between manipulations
        robot.execute_movement(mode=8)

        # === Step 2: Place the dice into the already open drawer ===
        # Place to 'drawer_top_place_left', which is inside open drawer
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Move to ready pose after the placement for safety
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()