from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for: Insert a pair of dice into the drawer that is open.
    Uses only the provided skills as specified.
    Assumptions:
      - 'yellow_dice' and 'green_dice' are used as the pair of dice.
      - Drawer1 is the only open & empty drawer, at 'ready-pose'.
      - The robot is initially at 'ready-pose'.
      - Only 'execute_pick' and 'execute_place' skills are used.
    """
    robot = RobotController()

    # Step 1: Pick up yellow dice from floor at ready-pose (axis=2: vertical approach)
    try:
        robot.execute_movement(Object["yellow_dice"], mode=1, axis=2)
    except Exception as e:
        print(f"Warning: Failed to pick yellow_dice - {e}")

    # Step 2: Place yellow dice into top drawer (drawer1)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Warning: Failed to place yellow_dice - {e}")

    # Step 3: Pick up green dice from floor at ready-pose
    try:
        robot.execute_movement(Object["green_dice"], mode=1, axis=2)
    except Exception as e:
        print(f"Warning: Failed to pick green_dice - {e}")

    # Step 4: Place green dice into top drawer (drawer1)
    try:
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as e:
        print(f"Warning: Failed to place green_dice - {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()