from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick handle3 from ready-pose
        if "drawer_bottom_handle" in Object:
            robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        else:
            print("Error: drawer_bottom_handle (handle3) not found in Object list.")

        # Step 2: Place handle3 in drawer1 at ready-pose
        if "drawer_top_place_left" in Object:
            robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=0)
        else:
            print("Error: drawer_top_place_left not found in Object list.")

        # Step 3: Pick handle2 from ready-pose
        if "drawer_middle_handle" in Object:
            robot.execute_movement(Object["drawer_middle_handle"], mode=1, axis=0)
        else:
            print("Error: drawer_middle_handle (handle2) not found in Object list.")

        # Step 4: Place handle2 in drawer1 at ready-pose
        if "drawer_top_place_right" in Object:
            robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=0)
        else:
            print("Error: drawer_top_place_right not found in Object list.")
    except Exception as e:
        print(f"Exception during execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()