from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    
    try:
        # Step 1: Pick handle1 (drawer_top_handle) at ready-pose
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        # Step 2: Place handle1 into drawer1 (drawer_top_place_left/right), at ready-pose
        # Since there's no clear separate "drawer place" for handles, we use drawer_top_place_left as the target location
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Step 3: Pick handle2 (drawer_middle_handle) at ready-pose
        robot.execute_movement(Object["drawer_middle_handle"], mode=1, axis=0)
        # Step 4: Place handle2 into drawer1 (drawer_top_place_left/right), at ready-pose
        # Place the second handle at drawer_top_place_right
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()