from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    
    # The task: Place two dice ("dice1", "dice2") into the open drawer ("drawer1").
    # Based on the object list provided in the environment, "dice1" is present in Object. "dice2" is referenced in the observation but not in the object list --
    # so let's assume "dice2" is mapped to "item2" (since "item2" is the only object fitting in the drawer and named as such in the objects).
    # However, for pick actions, we'll use axis = 2 (z-axis) for dice/items, and for place, also axis = 2 per conventions.

    # STEP 1: Pick dice1 from ready-pose
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print("Error in picking dice1:", e)
    
    # STEP 2: Place dice1 into drawer1 at ready-pose
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print("Error in placing dice1:", e)

    # STEP 3: Pick dice2 (assumed as item2) from ready-pose
    try:
        robot.execute_movement(Object["item2"], mode=1, axis=2)
    except Exception as e:
        print("Error in picking dice2/item2:", e)
    
    # STEP 4: Place dice2/item2 into drawer1 at ready-pose
    try:
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as e:
        print("Error in placing dice2/item2:", e)

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
