from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequential plan:
    1. execute_pick(dice1, ready-pose)
    2. execute_place(dice1, drawer1, ready-pose)
    3. execute_pick(dice2, ready-pose)
    4. execute_place(dice2, drawer1, ready-pose)
    """
    robot = RobotController()

    # The mapping from logical names to workspace poses is assumed done via Object dict.
    # Approach dice along z-axis (axis=2). Places along z-axis as well.
    # Graceful error handling for missing objects or exceptions.

    try:
        # Step 1: Pick dice1 from ready-pose
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick(dice1): {e}")

    try:
        # Step 2: Place dice1 into open drawer1 (location: ready-pose)
        # For placing, use a generic place position (default to dice1 pose for reference, axis=2)
        robot.execute_movement(Object["dice1"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place(dice1): {e}")

    try:
        # Step 3: Pick dice2 from ready-pose
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick(dice2): {e}")

    try:
        # Step 4: Place dice2 into open drawer1 (location: ready-pose)
        robot.execute_movement(Object["dice2"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place(dice2): {e}")


def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
