from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick dice1 at ready-pose
        if "dice1" in Object:
            obj_pick1 = Object["dice1"]
        else:
            raise KeyError("dice1 not found in Object list")
        robot.execute_movement(obj_pick1, mode=1, axis=2)

        # Step 2: execute_place dice1 into drawer1 at ready-pose
        if "drawer_top_place_left" in Object:
            obj_place1 = Object["drawer_top_place_left"]
        else:
            raise KeyError("drawer_top_place_left not found in Object list")
        robot.execute_movement(obj_place1, mode=2, axis=2)

        # Step 3: execute_pick item2 at ready-pose
        if "item2" in Object:
            obj_pick2 = Object["item2"]
        else:
            raise KeyError("item2 not found in Object list")
        robot.execute_movement(obj_pick2, mode=1, axis=2)

        # Step 4: execute_place item2 into drawer1 at ready-pose
        if "drawer_top_place_right" in Object:
            obj_place2 = Object["drawer_top_place_right"]
        else:
            raise KeyError("drawer_top_place_right not found in Object list")
        robot.execute_movement(obj_place2, mode=2, axis=2)

    except KeyError as e:
        print(f"Object key error: {e}")
    except Exception as e:
        print(f"Unexpected error during Long_horizon_task2_oracle_seq: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
