from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle execution sequence for:
    Goal: Move two dice to the drawer that's already open.
    Plan:
      1. Pick dice1 at ready-pose (axis=2 for general pick)
      2. Place dice1 in drawer1 at ready-pose (axis=2 for placement)
      3. Pick dice2 at ready-pose (axis=2)
      4. Place dice2 in drawer1 at ready-pose (axis=2)
    Assumptions:
      - "dice1" and "dice2" locations correspond to positions set up for picking.
      - All object keys in Object dictionary should exist.
      - "drawer1" open place is mapped to "drawer_top_place_left"/"drawer_top_place_right" or similar.
      - Use execute_movement with correct mode and axis for pick/place.
    """

    robot = RobotController()

    # Step 1: Pick dice1
    try:
        # Assume dice1 pick pose keyed as "dice1" in Object
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during pick of dice1: {e}")

    # Step 2: Place dice1 in the open drawer; assume target is left slot ("drawer_top_place_left")
    try:
        robot.execute_movement(mode=8)  # Move to ready pose for safety between actions if needed
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during placement of dice1: {e}")

    # Step 3: Pick dice2
    try:
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during pick of dice2: {e}")

    # Step 4: Place dice2 in the open drawer; assume target is right slot ("drawer_top_place_right")
    try:
        robot.execute_movement(mode=8)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during placement of dice2: {e}")

    # Final ready pose (optional)
    try:
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error returning to ready pose: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()