from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for: Insert a pair of dice into the drawer that is open.
    Plan steps (from specification):
      1. execute_pick(dice1, location_of_dice1)
      2. execute_place(dice1, open_drawer, location_of_drawer)
      3. execute_pick(dice2, location_of_dice2)
      4. execute_place(dice2, open_drawer, location_of_drawer)
    """

    robot = RobotController()

    try:
        # Step 1: Pick up dice1 (approach along z-axis: axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Move to ready pose after pick
        robot.execute_movement(mode=8)
        # Step 2: Place dice1 into drawer (use left place pose, approach along z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Move to ready pose after place
        robot.execute_movement(mode=8)

        # Step 3: Pick up dice2 (approach along z-axis: axis=2)
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
        # Move to ready pose after pick
        robot.execute_movement(mode=8)
        # Step 4: Place dice2 into drawer (use right place pose, approach along z-axis)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
        # Move to ready pose after place
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"Error during oracle sequence execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()