"""Module to insert a pair of dice into the open drawer using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def insert_pair_of_dice_into_open_drawer():
    """Insert a pair of dice into the open drawer."""
    robot_controller = RobotController()

    # Step 1: Move to the location of the pair of dice and pick them up
    try:
        robot_controller.execute_movement(Object["pair_of_dice"], mode=1, axis=0)
    except Exception as error:
        print(f"Error in execute_pick for pair_of_dice: {error}")

    # Step 2: Place the pair of dice into the open drawer (drawer1) at ready-pose
    try:
        robot_controller.execute_movement(Object["drawer1"], mode=2, axis=0)
    except Exception as error:
        print(f"Error in execute_place for pair_of_dice: {error}")

def main():
    """Main function to execute the task."""
    insert_pair_of_dice_into_open_drawer()

if __name__ == "__main__":
    main()