from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Place two dice into the open drawer (drawer1).
    Assumes dice1 and dice2 are on the floor and drawer1 is open and not full.
    """
    robot = RobotController()

    try:
        # Move to ready-pose if not already there
        robot.execute_go(Object["robot_pose"], Object["ready_pose"])

        # Pick up dice1 from the floor at ready-pose
        robot.execute_pick(Object["dice1"], Object["ready_pose"])
        # Place dice1 into drawer1 at ready-pose
        robot.execute_place(Object["dice1"], Object["drawer1"], Object["ready_pose"])

        # Pick up dice2 from the floor at ready-pose
        robot.execute_pick(Object["dice2"], Object["ready_pose"])
        # Place dice2 into drawer1 at ready-pose
        robot.execute_place(Object["dice2"], Object["drawer1"], Object["ready_pose"])

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """
    Main entry point for placing two dice into the open drawer.
    """
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()