"""Module to place two dice into any open drawer."""
from Object_list import Object
from skill_mapping import RobotController

def place_two_dice_in_open_drawer():
    """Place two dice into any open drawer."""
    robot = RobotController()

    # Find an open drawer
    open_drawer = None
    for drawer_name in ["drawer1", "drawer2", "drawer3"]:
        if Object[drawer_name]["is_open"]:
            open_drawer = drawer_name
            break

    if open_drawer is None:
        raise RuntimeError("No open drawer available.")

    # Place dice1
    robot.execute_movement(Object["dice1"], mode=1)
    robot.execute_movement(Object[open_drawer], mode=2)

    # Place dice2
    robot.execute_movement(Object["dice2"], mode=1)
    robot.execute_movement(Object[open_drawer], mode=2)

def main():
    """Main entry point."""
    place_two_dice_in_open_drawer()

if __name__ == "__main__":
    main()