"""Module to insert a pair of dice into the open drawer using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Insert dice1 and dice2 into the open drawer."""
    robot = RobotController()

    # Step 1: Pick dice1 at ready-pose (axis=2 for general object pick)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as error:
        print(f"Error during execute_pick for dice1: {error}")

    # Step 2: Place dice1 into drawer1 at ready-pose (axis=2 for general object place)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as error:
        print(f"Error during execute_place for dice1: {error}")

    # Step 3: Pick dice2 at ready-pose (axis=2 for general object pick)
    try:
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
    except Exception as error:
        print(f"Error during execute_pick for dice2: {error}")

    # Step 4: Place dice2 into drawer1 at ready-pose (axis=2 for general object place)
    try:
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as error:
        print(f"Error during execute_place for dice2: {error}")

def main():
    """Main function to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()