from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task_store_two_dice_in_open_drawer():
    """
    Store two dice (dice1 and dice2) in the open drawer (drawer1).
    """
    robot = RobotController()

    # Pick dice1 at ready-pose
    robot.execute_movement(Object["dice1"], mode=1, axis=2)
    # Place dice1 into drawer1 at ready-pose
    robot.execute_movement(Object["drawer1"], mode=2, axis=2)

    # Pick dice2 at ready-pose
    robot.execute_movement(Object["dice2"], mode=1, axis=2)
    # Place dice2 into drawer1 at ready-pose
    robot.execute_movement(Object["drawer1"], mode=2, axis=2)

def main():
    long_horizon_task_store_two_dice_in_open_drawer()

if __name__ == "__main__":
    main()