"""Module to insert a pair of dice into the open drawer."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Insert a pair of dice into the open drawer."""
    robot = RobotController()

    # Move to ready pose (optional, for safety)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=8)
    except Exception as exc:
        pass

    # Pick dice1 at ready-pose
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as exc:
        print(f"Error in picking dice1: {exc}")

    # Place dice1 in open drawer1 at ready-pose
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as exc:
        print(f"Error in placing dice1: {exc}")

    # Pick dice2 at ready-pose
    try:
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
    except Exception as exc:
        print(f"Error in picking dice2: {exc}")

    # Place dice2 in open drawer1 at ready-pose
    try:
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as exc:
        print(f"Error in placing dice2: {exc}")

def main():
    """Main function to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()