"""Module to store two dice in the open drawer (drawer1) as per task requirements."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to pick both dice and place them in the open drawer1."""
    robot = RobotController()

    # Pick dice1 at ready-pose
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as error:
        print(f"Error during execute_pick for dice1: {error}")

    # Place dice1 in drawer1 at ready-pose (drawer1 is open)
    try:
        robot.execute_movement(Object["drawer1"], mode=2, axis=2)
    except Exception as error:
        print(f"Error during execute_place for dice1: {error}")

    # Pick dice2 at ready-pose
    try:
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
    except Exception as error:
        print(f"Error during execute_pick for dice2: {error}")

    # Place dice2 in drawer1 at ready-pose (drawer1 remains open)
    try:
        robot.execute_movement(Object["drawer1"], mode=2, axis=2)
    except Exception as error:
        print(f"Error during execute_place for dice2: {error}")

def main():
    """Main entry point to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()