"""Module to move two dice into the already open drawer (drawer1)."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Moves dice1 and dice2 into the already open drawer (drawer1)."""
    robot = RobotController()

    # Move to dice1, pick it up
    robot.execute_movement(Object["dice1"], mode=1, axis=2)

    # Move to drawer1 (already open), place dice1
    robot.execute_movement(Object["drawer1"], mode=2, axis=2)

    # Move to dice2, pick it up
    robot.execute_movement(Object["dice2"], mode=1, axis=2)

    # Move to drawer1 (already open), place dice2
    robot.execute_movement(Object["drawer1"], mode=2, axis=2)

def main():
    """Main function to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()