from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle execution for: Put two dice in the already open drawer.
    Executes 'execute_pick' and 'execute_place' only as per specification.
    Approach dice and drawer positions vertically (axis=2).
    """
    robot = RobotController()
    try:
        # Step 1: Pick up dice1 (vertical approach)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 2: Place dice1 into the drawer at the left position (vertical approach)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Step 3: Pick up dice2 (vertical approach)
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
        # Step 4: Place dice2 into the drawer at the right position (vertical approach)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as e:
        print("Error during oracle sequence execution:", e)

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()