from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick up dice1 at its location (assumed axis=2, vertical approach)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 2: Move to drawer's open position (left) -- execute_go
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)
        # Step 3: Place dice1 into the drawer (left slot)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Step 4: Pick up dice2 at its location (assumed axis=2)
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
        # Step 5: Move to drawer's open position (right) -- execute_go
        robot.execute_movement(Object["drawer_top_place_right"], mode=7)
        # Step 6: Place dice2 into the drawer (right slot)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()