from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle plan execution for: Place two dice into the open drawer.
    Steps executed according to the specification:
      1. execute_pick('dice1', 'dice1_location')
      2. execute_place('dice1', 'drawer', 'drawer_location')
      3. execute_pick('dice2', 'dice2_location')
      4. execute_place('dice2', 'drawer', 'drawer_location')
    Here, Object["drawer_top_place_left"] and Object["drawer_top_place_right"] are used as
    positions inside the open drawer for placement.
    """
    robot = RobotController()
    try:
        # Step 1: Pick up dice1 (using z axis approach)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 2: Place dice1 in open drawer (left position)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Step 3: Pick up dice2 (using z axis approach)
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
        # Step 4: Place dice2 in open drawer (right position)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
        # Optional: move robot to ready pose for safety
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"An error occurred during execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()