from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # [Frozen Code Start]
    robot.execute_movement(Object["floor"], mode=7)
    # [Frozen Code End]

    # Step 1: Pick dice1 from pick_location1 (assume dice1 is on the floor; approach along z-axis)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error in Step 1 (execute_pick dice1): {e}")

    # Step 2: Place dice1 into the already open drawer (assume left place position; approach along z-axis)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in Step 2 (execute_place dice1): {e}")

    # Step 3: Pick dice2 from pick_location2 (assume dice2 is on the floor; approach along z-axis)
    try:
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
    except Exception as e:
        print(f"Error in Step 3 (execute_pick dice2): {e}")

    # Step 4: Place dice2 into the already open drawer (assume right place position; approach along z-axis)
    try:
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in Step 4 (execute_place dice2): {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()