from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequential plan for:
    Goal: Insert a pair of dice into the drawer that is open.
    Specification steps:
      1. Pick dice1 from its current location (z-axis approach).
      2. Place dice1 into the open drawer (left place, z-axis approach).
      3. Pick dice2 from its current location (z-axis approach).
      4. Place dice2 into the open drawer (right place, z-axis approach).
    Only uses skills: execute_pick (mode=1), execute_place (mode=2), and places the robot in ready pose (mode=8) between actions for robustness.
    """

    robot = RobotController()

    try:
        # Step 1: Pick dice1 using z-axis approach
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 2: Place dice1 into the open drawer (left place)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Robot to ready pose for safety between actions
        robot.execute_movement(mode=8)

        # Step 3: Pick dice2 using z-axis approach
        robot.execute_movement(Object["dice2"], mode=1, axis=2)

        # Step 4: Place dice2 into the open drawer (right place)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)

        # Finish by moving to ready pose
        robot.execute_movement(mode=8)

    except KeyError as e:
        print(f"Object key error in oracle sequence: {e}")
    except Exception as e:
        print(f"Unexpected error during Long_horizon_task2_oracle_seq: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()