(define (domain primitive_skills_static_lock_v2)

  (:requirements :strips :typing :conditional-effects)

  (:types object drawer location)

  (:predicates

    (on-floor ?o - object)

    (in-drawer ?o - object ?d - drawer)

    (drawer-locked   ?d - drawer)

    (drawer-unlocked ?d - drawer)

    (drawer-open     ?d - drawer)

    (drawer-closed   ?d - drawer)

    (drawer-full      ?d - drawer)

    (drawer-empty     ?d - drawer)

    (drawer-partially-filled ?d - drawer)

    (handle-of ?h - object ?d - drawer)

    (holding ?o - object)

    (hand-empty)

    (robot-free)

    (robot-at ?p - location)

  )

  (:action execute_pick

    :parameters (?o - object ?p - location)

    :precondition (and (on-floor ?o) (hand-empty) (robot-free) (robot-at ?p))

    :effect (and (holding ?o)

                 (not (on-floor ?o))

                 (not (hand-empty))

                 (not (robot-free)))

  )

  (:action execute_place

    :parameters (?o - object ?d - drawer ?p - location)

    :precondition (and (holding ?o)

                       (drawer-open ?d)

                       (not (drawer-full ?d))

                       (robot-at ?p))

    :effect (and (in-drawer ?o ?d)

                 (not (holding ?o))

                 (hand-empty)

                 (robot-free)

                 (when (drawer-empty ?d)

                       (and (not (drawer-empty ?d))

                            (drawer-partially-filled ?d)))

                 (when (drawer-partially-filled ?d)

                       (and (not (drawer-partially-filled ?d))

                            (drawer-full ?d))))

  )

  (:action execute_pull

    :parameters (?d - drawer ?h - object ?p - location)

    :precondition (and (holding ?h)

                       (handle-of ?h ?d)

                       (drawer-unlocked ?d)

                       (drawer-closed ?d)

                       (robot-at ?p))

    :effect (and (drawer-open ?d)

                 (not (drawer-closed ?d))

                 (not (holding ?h))

                 (hand-empty)

                 (robot-free))

  )

  (:action execute_push

    :parameters (?d - drawer ?p - location)

    :precondition (and (drawer-open ?d)

                       (robot-free) (robot-at ?p))

    :effect (and (not (drawer-open ?d))

                 (drawer-closed ?d))

  )

  (:action execute_go

    :parameters (?from ?to - location)

    :precondition (and (robot-free) (robot-at ?from))

    :effect (and (robot-at ?to) (not (robot-at ?from)))

  )

  (:action execute_sweep

    :parameters (?o - object ?p - location)

    :precondition (and (on-floor ?o) (robot-free) (robot-at ?p))

    :effect ()

  )

  (:action execute_gripper

    :parameters ()

    :precondition (robot-free)

    :effect ()

  )

)
