from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # === Step 1: execute_pick on a handle ===
    # Open one drawer: select handle and corresponding drawer.
    # From the observation and object list:
    #  - Available handles: handle1, handle2, handle3
    #  - Mapping: handle1 <-> drawer1 (drawer_top_handle), handle2 <-> drawer2 (drawer_middle_handle), handle3 <-> drawer3 (drawer_bottom_handle)
    #  - Use the top drawer for clarity/conventionality.
    # Mapping in Object_list: 
    #   - "drawer_top_handle" -> handle1
    #   - "drawer_top_place_left"/"right" -> drawer1
    # Correspondences by designer's naming.

    # For picking a handle, axis=0 (approach along x-axis).
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick (drawer_top_handle): {e}")
        return

    # === Step 2: execute_pull on the drawer via handle ===
    # execute_pull arguments: (drawer, handle, location)
    # PDDL: (:action execute_pull :parameters (?d - drawer ?h - object ?p - location))
    # In execute_movement: Object parameter is the handle pose for pulling as well.
    # In skill code: mode=4 triggers execute_pull.
    # Set distance appropriately for full drawer open.
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull (drawer_top_handle): {e}")
        return

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()