from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    
    # === Plan to pull open a single drawer ===
    # According to the problem, observation, and specification:
    # - All handles are on the floor: drawer_top_handle, drawer_middle_handle, drawer_bottom_handle
    # - Each handle is associated with a drawer; let's pick the top as a convention (drawer_top_handle -> drawer1)
    # - The robot must pick the handle and then pull (open) the associated drawer

    try:
        # 1. Pick up the handle corresponding to the top drawer, at its location (on the floor)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        
        # 2. Pull to open the drawer using the handle
        #    The motion should be along the "pull" axis (drawer opens - usually outwards, x-axis)
        #    Give a reasonable pull distance (e.g., 0.1m as in the skeleton)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, distance=0.1)
    
    except Exception as e:
        print("Error occurred during execution of the oracle plan:", e)

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()