from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Executes the oracle plan for: "Slide one drawer open."
    Follows the plan steps as per specification:
      1. execute_pick(handle1, ready-pose)
      2. execute_pull(drawer1, handle1, ready-pose)
    Mapping to object list and Object dictionary:
      handle1 → "drawer_top_handle"
      drawer1 → drawer corresponding to the top handle (in Object list, only handles and places are provided explicitly but we follow naming consistency)
      ready-pose → not needed explicitly; robot starts from there as per the observation
    """

    robot = RobotController()

    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick on drawer_bottom_handle: {e}")

    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during execute_pull on drawer_bottom_handle: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()