from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # We need to: Slide one drawer open using only execute_pick and execute_pull.
    # From observation:
    #  - There are three drawers, each with a handle object: 
    #    handle3 for drawer3, handle2 for drawer2, handle1 for drawer1.
    #    The handles are all on the floor.

    # For simplicity, open the top drawer (drawer1) using its handle ("drawer_top_handle" for handle1).
    # According to object_names: 
    #  - "drawer_top_handle" maps to handle1 (used for drawer1, which is "drawer1")

    # Map handles and locations to Object list entries:
    #   - "<handle_object>" => Object["drawer_top_handle"]
    #   - "<handle_location>" => the handle is on the floor, but robot can pick from there.
    #   - "<drawer>" => drawer1 (represented by handle1's handle; skill uses handle1 for pull to drawer1).
    #   - "<pull_location>" => arbitrary, but the robot can stay in same place for these skills.

    try:
        # Step 1: execute_pick(handle_object, handle_location)
        # Pick up the top drawer's handle (assumed "drawer_top_handle"/handle1) from its location
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Step 2: execute_pull(drawer, handle_object, pull_location)
        # Pull the drawer using the handle just picked up
        robot.execute_movement(Object["drawer_top_handle"], mode=4, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()