from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick handle3 (drawer_top_handle) at ready-pose
        # handle3 corresponds to Object["drawer_top_handle"], axis=0 for drawer handle
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print("Error during execute_pick for handle3:", e)
        return

    try:
        # Step 2: Pull to open drawer3 (top drawer) with handle3 at ready-pose
        # This is a pull primitive, so use mode=4 with axis=0 and a slightly longer distance (for opening drawer)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print("Error during execute_pull for drawer3 (top drawer):", e)
        return

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
