from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick(handle3, ready-pose)
        # Object mapping: handle3 -> drawer_top_handle in Object_list
        # Approach drawer handles along the x-axis: axis=0
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Step 2: execute_pull(drawer3, handle3, ready-pose)
        # Object mapping: drawer3 -> the handle we just picked, so use drawer_top_handle pose
        # execute_pull uses mode=4, axis=0 (approach handle/drawer along x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error occurred during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()