from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick the handle3 (mapped here as drawer_bottom_handle based on ordering)
        # From the object_names mapping, handle3 corresponds to "drawer_bottom_handle"
        # "ready-pose" location - not needed in skill call, object pose from Object_list is used
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        # Step 2: Pull open drawer3 using handle3 ("drawer_bottom_handle"), approach along x-axis
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during plan execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()