from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    
    try:
        # Step 1: execute_pick(handle3, ready-pose)
        # "handle3" is the handle for "drawer3" and "ready-pose" is the robot initial location.
        # According to object_names, map "handle3" to "drawer_bottom_handle"
        # ready-pose is not an explicit object but assumed as robot's current pose
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick(handle3): {e}")
        return

    try:
        # Step 2: execute_pull(drawer3, handle3, ready-pose)
        # "drawer3" is the bottom drawer => no positional handle, just need bottom drawer handle, approach axis 0, pull (mode 4)
        # The plan assumes the robot is still at the same location after picking handle
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)
    except Exception as e:
        print(f"Error during execute_pull(drawer3): {e}")
        return

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()