from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick(handle3, drawer3)
        # Map handle3 to "drawer_bottom_handle" (since object_names is a mapping to handles/objects used in the environment)
        # The parameter list in the spec is ["handle3","drawer3"], but for execute_pick, use only the handle's pose.
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 2: execute_pull(drawer3, handle3, drawer3)
        # The first parameter is the drawer ("drawer3"), second is the handle ("handle3"), third is the location (we use handle pose as contact point).
        # For pulling a drawer by handle, axis=0 (pull along x), and use some distance, e.g., distance=0.1 (typical pull).
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
