from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick on handle_bottom at ready-pose
        #   - Pick up the handle at the ready pose.
        #   - Use axis=0 for handle (approach from x-axis as per guidelines).
        if "drawer_bottom_handle" in Object:
            robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        else:
            print("Error: drawer_bottom_handle not found in Object list.")
            return

        # Step 2: execute_pull on drawer_bottom using handle_bottom at ready-pose
        #   - Pull the drawer open, holding the handle.
        #   - Position is handle's since it's attached to drawer. Approach direction remains axis=0.
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

    except Exception as e:
        print(f"Exception occurred during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()