from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick up the bottom handle ("handle_bottom") at "ready-pose"
        # Use axis=0 for handles (drawer handles: grasp along x-axis)
        robot.execute_movement(Object["handle_bottom"], mode=1, axis=0, pose0=Object["ready-pose"])
        # Step 2: Pull the bottom drawer ("drawer_bottom") using "handle_bottom", at "ready-pose"
        # For pulling, also approach along x-axis. Use distance=0.1 for sufficient travel.
        robot.execute_movement(Object["drawer_bottom"], mode=4, axis=0, distance=0.1, pose1=Object["handle_bottom"], pose0=Object["ready-pose"])
    except KeyError as e:
        print(f"Object name error: {e}. Please check if the object exists in the Object list.")
    except Exception as ex:
        print(f"An error occurred during task execution: {ex}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()