from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # === Step 1: Pick up the handle for the bottom drawer ===
    # The handle is "drawer_bottom_handle", approach axis=0 (x-axis) for handle manipulation
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print("Error during execute_pick (drawer_bottom_handle):", e)
        return

    # === Step 2: Pull to open the bottom drawer using the handle ===
    # The pull is performed at the same location as the handle, axis=0 (x-axis)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print("Error during execute_pull (drawer_bottom_handle):", e)
        return

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()