from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick handle_bottom (i.e., "drawer_bottom_handle") at "ready-pose"
        # axis=0 since it's a handle (approach along x-axis)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in Step 1 - execute_pick: {e}")

    try:
        # Step 2: Pull to open drawer_bottom via handle_bottom at "ready-pose"
        # mode=4 -> execute_pull
        # Handles are typically pulled along x-axis, so axis=0, distance=0.1 is reasonable
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in Step 2 - execute_pull: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()